/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.config;

import fuzs.betteranimationscollection.client.BetterAnimationsCollectionClient;
import fuzs.betteranimationscollection.client.element.ModelElementBase;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ClientConfig
implements ConfigCore {
    @Config(category={"general"}, name="mob_blacklist", description={"Mob variants that shouldn't have any model changes applied to them.", "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported."})
    List<String> mobBlacklistRaw = EntryCollectionBuilder.getKeyList((class_5321)class_2378.field_25107, (Object[])new class_1299[0]);
    @Config(category={"general"}, description={"Block range for sound detection system to look for a mob that made a certain sound on the server, so the client may play an animation.", "The client is not sent an exact position, so the mob's location must be estimated."})
    @Config.DoubleRange(min=0.5, max=8.0)
    public double soundDetectionRange = 1.5;
    public Set<class_1299<?>> mobBlacklist;

    public void addToBuilder(AbstractConfigBuilder builder, ValueCallback callback) {
        builder.push("models");
        for (Map.Entry<class_2960, ModelElementBase> entry : BetterAnimationsCollectionClient.MODEL_ELEMENTS.entrySet()) {
            callback.accept((Supplier)builder.comment(entry.getValue().modelDescription()).define(entry.getKey().method_12832(), true), entry.getValue()::setEnabled);
        }
        builder.pop();
        for (Map.Entry<class_2960, ModelElementBase> entry : BetterAnimationsCollectionClient.MODEL_ELEMENTS.entrySet()) {
            builder.push(entry.getKey().method_12832());
            entry.getValue().setupModelConfig(builder, callback);
            builder.pop();
        }
    }

    public void afterConfigReload() {
        Set mobBlacklist = EntryCollectionBuilder.of((class_5321)class_2378.field_25107).buildSet(this.mobBlacklistRaw);
        if (!mobBlacklist.equals(this.mobBlacklist)) {
            boolean initialReload = this.mobBlacklist == null;
            this.mobBlacklist = mobBlacklist;
            if (!initialReload) {
                BetterAnimationsCollectionClient.buildAnimatedModels(false, true);
            }
        }
    }
}

